  <!DOCTYPE html>
  <html lang="en">

  <head>
      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title>Document</title>
      <script src="https://cdn.jsdelivr.net/npm/@tailwindcss/browser@4"></script>

      <style>
          body {

              font-family: 'Poppins', sans-serif;

          }

          html {
              scroll-behavior: smooth;
          }
      </style>
      <link rel="preconnect" href="https://fonts.googleapis.com">
      <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
      <link
          href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
          rel="stylesheet">

  </head>

  <body style="background: <?php echo e($setup->main_color); ?>">
      <!-- component -->
      <div class="bg-[<?php echo e($setup->main_color); ?>] font-sans w-full m-0 border-b-1 border-indigo-500">
          <div>
              <div class="container mx-auto px-4">
                  <div class="flex items-center justify-between py-4">
                      <div style="color: <?php echo e($setup->logo_text_color); ?>" class="text-2xl font-bold">

                          <a href="/"><?php echo e(env('APP_NAME')); ?></a>
                      </div>

                      <div class="hidden sm:flex sm:items-center text-white space-x-4">
                          <a href="#home" class="text-sm font-semibold hover:text-purple-600">Home</a>

                          <div class="relative group">
                              <a href="#services" class="text-sm font-semibold hover:text-purple-600">Services</a>
                              <div
                                  class="absolute left-0 mt-2 w-48 bg-white text-black rounded-md shadow-lg opacity-0 group-hover:opacity-100 transition-opacity duration-200 z-10">

                                  <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                      <a href="<?php echo e(route('service.show', $d->id)); ?>"
                                          class="block px-4 py-2 text-sm hover:bg-gray-100"><?php echo e($d->title); ?></a>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                              </div>
                          </div>

                          <a href="#blog" class="text-sm font-semibold hover:text-purple-600">Blog</a>
                          <a href="#faq" class="text-sm font-semibold hover:text-purple-600">F.A.Q</a>
                      </div>


                      <div class="hidden sm:flex sm:items-center">

                          <a href="#contact"
                              class="text-sm font-semibold border px-4 py-2 rounded-lg text-[<?php echo e($setup->navbar_button_color); ?>] border-[<?php echo e($setup->navbar_button_color); ?>]">
                              Contact Us
                          </a>
                      </div>

                      <div id="menu-toggle" class="sm:hidden cursor-pointer">
                          <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6 text-purple-600" viewBox="0 0 24 24">
                              <path fill="currentColor"
                                  d="M12.9499909,17 C12.7183558,18.1411202 11.709479,19 10.5,19 C9.29052104,19 8.28164422,18.1411202 8.05000906,17 L3.5,17 C3.22385763,17 3,16.7761424 3,16.5 C3,16.2238576 3.22385763,16 3.5,16 L8.05000906,16 C8.28164422,14.8588798 9.29052104,14 10.5,14 C11.709479,14 12.7183558,14.8588798 12.9499909,16 L20.5,16 C20.7761424,16 21,16.2238576 21,16.5 C21,16.7761424 20.7761424,17 20.5,17 L12.9499909,17 Z M18.9499909,12 C18.7183558,13.1411202 17.709479,14 16.5,14 C15.290521,14 14.2816442,13.1411202 14.0500091,12 L3.5,12 C3.22385763,12 3,11.7761424 3,11.5 C3,11.2238576 3.22385763,11 3.5,11 L14.0500091,11 C14.2816442,9.85887984 15.290521,9 16.5,9 C17.709479,9 18.7183558,9.85887984 18.9499909,11 L20.5,11 C20.7761424,11 21,11.2238576 21,11.5 C21,11.7761424 20.7761424,12 20.5,12 L18.9499909,12 Z M9.94999094,7 C9.71835578,8.14112016 8.70947896,9 7.5,9 C6.29052104,9 5.28164422,8.14112016 5.05000906,7 L3.5,7 C3.22385763,7 3,6.77614237 3,6.5 C3,6.22385763 3.22385763,6 3.5,6 L5.05000906,6 C5.28164422,4.85887984 6.29052104,4 7.5,4 C8.70947896,4 9.71835578,4.85887984 9.94999094,6 L20.5,6 C20.7761424,6 21,6.22385763 21,6.5 C21,6.77614237 20.7761424,7 20.5,7 L9.94999094,7 Z M7.5,8 C8.32842712,8 9,7.32842712 9,6.5 C9,5.67157288 8.32842712,5 7.5,5 C6.67157288,5 6,5.67157288 6,6.5 C6,7.32842712 6.67157288,8 7.5,8 Z M16.5,13 C17.3284271,13 18,12.3284271 18,11.5 C18,10.6715729 17.3284271,10 16.5,10 C15.6715729,10 15,10.6715729 15,11.5 C15,12.3284271 15.6715729,13 16.5,13 Z M10.5,18 C11.3284271,18 12,17.3284271 12,16.5 C12,15.6715729 11.3284271,15 10.5,15 C9.67157288,15 9,15.6715729 9,16.5 C9,17.3284271 9.67157288,18 10.5,18 Z" />
                          </svg>
                      </div>
                  </div>

                  <div class="hidden sm:hidden bg-[#18112D] py-2" id="mobile-menu">
                      <div class="flex flex-col">
                          <a href="#"
                              class="text-gray-400 text-sm font-semibold hover:text-purple-600 mb-1">Home</a>
                          <a href="#" class="text-gray-400 text-sm font-semibold hover:text-purple-600 mb-1">About
                              Us</a>
                          <a href="#"
                              class="text-gray-400 text-sm font-semibold hover:text-purple-600 mb-1">Services</a>
                          <a href="#"
                              class="text-gray-400 text-sm font-semibold hover:text-purple-600 mb-1">Blog</a>

                      </div>
                  </div>
              </div>
          </div>
      </div>




      <?php echo $__env->yieldContent('content'); ?>







      <footer class="text-white text-center py-3">
          Copyright ©2024 <?php echo e(env('APP_NAME')); ?>. All right reserved. | Developed by <a
              href="https://shahariarahmad.github.io/" class="text-yellow-300 hover:text-yellow-400"
              target="blank">Shahariar</a>
      </footer>

      <script>
          const menuToggle = document.getElementById('menu-toggle');
          const mobileMenu = document.getElementById('mobile-menu');

          menuToggle.addEventListener('click', () => {
              mobileMenu.classList.toggle('hidden');
          });
      </script>

     <script>
    document.querySelectorAll(".question").forEach(question => {
        const hoverColor = question.getAttribute("data-hover-color");

        question.addEventListener("click", () => {
            const faqItem = question.closest(".faq-item");
            const answer = faqItem.querySelector(".answercont");
            const icon = question.querySelector("span");

            const isActive = question.classList.contains("active");

            // Close all questions
            document.querySelectorAll(".question.active").forEach(activeQ => {
                activeQ.classList.remove("active");
                activeQ.setAttribute("aria-expanded", "false");

                // Reset previously set inline background
                activeQ.style.background = "";

                const activeAnswer = activeQ.closest(".faq-item").querySelector(".answercont");
                const activeIcon = activeQ.querySelector("span");

                activeAnswer.style.maxHeight = 0;
                activeIcon.style.transform = "rotate(0deg)";
            });

            // If this wasn't already active, open it
            if (!isActive) {
                question.classList.add("active");
                question.setAttribute("aria-expanded", "true");

                // Apply gradient or color from data-hover-color
                question.style.background = hoverColor;

                answer.style.maxHeight = answer.scrollHeight + "px";
                icon.style.transform = "rotate(45deg)";
            }
        });
    });
</script>


      <script>
          const guysInput = document.querySelector('input[name="guys"]');
          const girlsInput = document.querySelector('input[name="girls"]');
          const partySizeInput = document.querySelector('input[name="party_size"]');

          function updatePartySize() {
              const guys = parseInt(guysInput.value) || 0;
              const girls = parseInt(girlsInput.value) || 0;
              const total = guys + girls;

              partySizeInput.value = total;
          }

          guysInput.addEventListener('input', updatePartySize);
          girlsInput.addEventListener('input', updatePartySize);
      </script>




  </body>

  </html>
<?php /**PATH D:\Upwork\DirtyDancer\resources\views/app.blade.php ENDPATH**/ ?>