<?php $__env->startSection('content'); ?>
    <div class="container mx-auto py-5">
        <div class="card">
            <div class="card-title px-3 pt-3">
                <h3>All Service Posts</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead class="thead-dark">
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Photo</th>
                                <th scope="col">Title</th>
                                <th scope="col">Author</th>
                                <th scope="col">Created At</th>
                                <th scope="col">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th scope="row"><?php echo e($loop->iteration); ?></th>
                                    <td>
                                        <img src="<?php echo e(asset($d->photo)); ?>" alt="" style="width: 50px; height: 50px;">
                                    </td>
                                    <td><?php echo e($d->title); ?></td>
                                    <td><?php echo e(Str::limit(strip_tags($d->content), 200, ' ...')); ?></td>
                                    <td><?php echo e($d->created_at->format('D, M Y')); ?></td>
                                    <td>

                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <a href="<?php echo e(route('service.edit', $d->id)); ?>" class="btn btn-primary">Edit</a>
                                            
                                            <a href="<?php echo e(route('service.delete', $d->id)); ?>" class="btn btn-danger">Delete</a>
                                        </div>




                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="card-footer">
                <?php echo e($services->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Upwork\DirtyDancer\resources\views/service/index.blade.php ENDPATH**/ ?>