<?php $__env->startSection('content'); ?>
    <div class="container mx-auto py-5">
        <div class="card">
            <div class="card-title p-3">
                <h3>Publish F.A.Q</h3>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('faq.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <!-- Image Upload (optional) -->
                    <div class="form-group my-3">
                        <label>Question</label>
                        <input required type="text" name="question" class="form-control" placeholder="Write a question...">
                    </div>
                    <!-- Summernote Editor for Content -->
                    <label>Answer</label>
                    <textarea required name="answer" class="form-control" rows="5" placeholder="Write content ..."></textarea>



                    <div class="mt-4">
                        <button type="submit" class="btn btn-success" style="float: right;">Publish</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="container mx-auto py-5">
        <div class="card">
            <div class="card-title px-3 pt-3">
                <h3>All F.A.Q</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead class="thead-dark">
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Question</th>
                                <th scope="col">Answer</th>
                                <th scope="col">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $faq; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th scope="row"><?php echo e($loop->iteration); ?></th>
                                    <td><?php echo e($d->question); ?></td>
                                    <td><?php echo e(Str::limit(strip_tags($d->answer), 200, ' ...')); ?></td>
                                    <td>

                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <a href="<?php echo e(route('faq.edit', $d->id)); ?>" class="btn btn-primary">Edit</a>
                                            <a href="<?php echo e(route('faq.delete', $d->id)); ?>" class="btn btn-danger">Delete</a>
                                        </div>




                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="card-footer">
                <?php echo e($faq->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Upwork\DirtyDancer\resources\views/faq/index.blade.php ENDPATH**/ ?>