  @extends('app')
  @section('content')
      <section id="home" class="relative bg-cover bg-center bg-no-repeat py-24 px-6 sm:py-32 lg:px-8"
          style="background-image: url({{ asset($setup->bottle_image) }});">
          <div class="mb-12">
    <h1 class="text-4xl font-semibold text-center text-white">{{ $setup->bottle_title }}</h1>
          <p class="font-semibold text-center text-white">{{ $setup->bottle_subtitle }}</p>
          </div>

          <div
              class="max-w-7xl mx-auto grid grid-cols-1 lg:grid-cols-2 gap-12 items-center p-10 rounded-2xl shadow-lg backdrop-blur-sm backdrop-saturate-100 bg-[rgba(17,25,40,0.61)] rounded-[12px] border border-[rgba(255,255,255,0.125)]">
              <!-- Right: Image -->
              <div class="hidden lg:block">
                  <img src="{{ asset($setup->booking_card) }}" alt="Contact Illustration"
                      class="w-full h-auto rounded-xl shadow-md object-cover">
              </div>

              <!-- Left: Contact Form -->
              <div>

                  <form action="{{ route('table-booking.store') }}" method="post"
                      class="grid grid-cols-1 sm:grid-cols-2 gap-4 max-w-2xl mx-auto text-white">
                      @csrf
                      <!-- First Name -->
                      <input type="text" placeholder="First name" name="first_name"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Last Name -->
                      <input type="text" placeholder="Last name" name="last_name"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Phone -->
                      <input type="text" placeholder="Phone number" name="phone"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Email -->
                      <input type="email" name="email" placeholder="E-mail address"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Event Date -->
                      <input type="date" name="date" placeholder="Event Date"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Budget -->
                      <input type="text" name="budget" placeholder="Approximate Budget"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Party Size -->
                      <input type="number" name="party_size" placeholder="Auto Fill"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Number of Guys -->
                      <input type="number" name="guys" placeholder="Number of Guys"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Number of Girls -->
                      <input type="number" name="girls" placeholder="Number of Girls"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Message (Full Width) -->
                      <textarea rows="3" name="message" placeholder="Write your message..."
                          class="sm:col-span-2 bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0"></textarea>

                      <!-- Submit Button -->
                      <button type="submit" style="background: {{ $setup->bottle_color }}"
                          class="cursor-pointer sm:col-span-2 mt-2 w-full rounded-md px-4 py-3 font-semibold text-white shadow hover:opacity-90">
                          Book a bottle
                      </button>
                  </form>



              </div>


          </div>
      </section>

      <section class="relative bg-cover bg-center bg-no-repeat py-24 px-6 sm:py-32 lg:px-8"
          style="background-image: url({{ asset($setup->booking_image) }});">
          <div
              class="max-w-7xl mx-auto grid grid-cols-1 lg:grid-cols-2 gap-12 items-center backdrop-blur-sm backdrop-saturate-100 bg-[rgba(17,25,40,0.61)] rounded-[12px] border border-[rgba(255,255,255,0.125)] p-10 rounded-2xl shadow-lg">
              <div class="text-white">
                  <h1 class="text-4xl font-semibold text-white">{{ $setup->signup_title }}</h1>
                  <p>{{ $setup->signup_subtitle }}</p>
              </div>

              <!-- Left: Contact Form -->
              <div>
                  <form action="{{ route('registration.store') }}" method="post"
                      class="grid grid-cols-1 sm:grid-cols-2 gap-4 max-w-2xl mx-auto text-white">
                      @csrf

                      <!-- First Name -->
                      <input type="text" name="first_name" placeholder="First name"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Last Name -->
                      <input type="text" name="last_name" placeholder="Last name"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Phone Number -->
                      <input type="text" name="phone" placeholder="Phone number"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Email -->
                      <input type="email" name="email" placeholder="E-mail address"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Birthdate -->
                      <input type="date" name="birthdate" placeholder="Birthdate"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Height -->
                      <input type="text" name="height" placeholder="Height (in cm or ft)"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Instagram Handle -->
                      <input type="text" name="instagram" placeholder="Instagram Handle"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Agency -->
                      <input type="text" name="agency" placeholder="Agency (if any)"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Dates in New York -->
                      <input type="text" name="dates_in_ny" placeholder="Dates in New York"
                          class="bg-[#040515] text-white placeholder-white rounded-md px-4 py-2 w-full outline-none focus:ring-0" />

                      <!-- Submit Button -->
                      <button type="submit" style="background: {{ $setup->bottle_color }}"
                          class="sm:col-span-2 mt-2 w-full cursor-pointer rounded-md px-4 py-3 font-semibold text-white shadow hover:opacity-90">
                          Sign Up
                      </button>

                  </form>
              </div>
          </div>
      </section>

      <section>
          <div class="container mx-auto px-4 py-10">
              <div class="flex flex-col sm:flex-row items-center justify-between gap-6 sm:gap-12 py-12">
                  <p class="text-4xl sm:text-5xl font-semibold text-white text-center sm:text-left w-full sm:w-1/2">
                      Check out the blog of our previous events!
                  </p>
                  {{-- <button
                      class="bg-gradient-to-r from-blue-500 to-pink-500 text-white font-semibold px-6 py-3 rounded-md shadow hover:opacity-90 w-full sm:w-auto">
                      Read All Blog
                  </button> --}}
              </div>

              <div id="blog" class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-12 px-4">
                  @foreach ($blogs as $d)
                      <div
                          class="bg-[#18112D] border border-[{{$setup->blog_border_color}}] rounded-2xl shadow-md overflow-hidden grid grid-rows-[auto_1fr_auto]">
                          <!-- Image -->
                          <div class="h-56 overflow-hidden">
                              <img src="{{ asset($d->photo) }}" alt="card-image" class="w-full h-full object-cover" />
                          </div>

                          <!-- Content -->
                          <div class="p-5 grid grid-rows-[auto_1fr] gap-4">
                              <h6 class="text-white text-xl font-semibold">{{ $d->title }}</h6>
                              <p class="text-white font-light leading-relaxed">
                                  {{ Str::limit(strip_tags($d->content), 150, ' ...') }}
                              </p>
                          </div>

                          <!-- Button -->
                          <div class="px-5 pb-5">
                              <a href="{{ route('blog.show', $d->id) }}"
                                  class="block text-center bg-slate-800 text-white text-sm font-medium py-2 px-4 rounded-md hover:bg-slate-700 transition-all">
                                  Read more
                              </a>
                          </div>
                      </div>
                  @endforeach
              </div>


          </div>


      </section>

      <section id="faq" class="container mx-auto py-[100px]">
          <h1 class="text-4xl font-bold mb-6 text-white text-center">Frequently Asked Questions</h1>

          <div class="grid grid-cols-1 w-3/4 mx-auto gap-6">
              @foreach ($faq as $d)
                  <!-- FAQ Item -->
                  <div class="faq-item bg-[{{ $setup->faq_color }}] text-white rounded-2xl shadow-md overflow-hidden">
                      <div data-hover-color="{{ rtrim($setup->faq_hover_color, ';') }}" class="question text-lg font-semibold px-5 py-4 cursor-pointer relative flex items-center transition-colors duration-300"
                          role="button" tabindex="0" aria-expanded="false">
                          {{ $d->question }}
                          <span class="absolute right-5 text-2xl transition-transform duration-200">+</span>
                      </div>
                      <div class="answercont max-h-0 overflow-hidden transition-all duration-300 bg-white text-black">
                          <div class="answer px-5 pb-5 pt-0 leading-relaxed">
                              {{ $d->answer }}
                          </div>
                      </div>
                  </div>
              @endforeach
          </div>



      </section>


      <section id="contact" class="text-center text-white py-12 border-gray-700 border-t-1 border-b-1">

          <h1 class="text-4xl py-12">{{ env('APP_NAME') }}</h1>

          <div class="flex justify-center space-x-4 mb-12 text-lg">
              Connect with us on social media.
          </div>
          <div class="flex justify-center space-x-4">






              <!-- Facebook -->
              <a href="{{ $setup->facebook }}"
                  class="[&>svg]:h-5 [&>svg]:w-5 p-2 bg-[#191E42] rounded-md  transition-all duration-300 hover:bg-gradient-to-r hover:from-purple-600 hover:to-blue-500 cursor-pointer">
                  <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 320 512">
                      <!--!Font Awesome Free 6.5.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc. -->
                      <path
                          d="M80 299.3V512H196V299.3h86.5l18-97.8H196V166.9c0-51.7 20.3-71.5 72.7-71.5c16.3 0 29.4 .4 37 1.2V7.9C291.4 4 256.4 0 236.2 0C129.3 0 80 50.5 80 159.4v42.1H14v97.8H80z" />
                  </svg>
              </a>

              <!-- Instagram -->
              <a href="{{ $setup->instagram }}"
                  class="[&>svg]:h-5 [&>svg]:w-5 p-2 bg-[#191E42] rounded-md  transition-all duration-300 hover:bg-gradient-to-r hover:from-purple-600 hover:to-blue-500 cursor-pointer">
                  <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 448 512">
                      <!--!Font Awesome Free 6.5.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc. -->
                      <path
                          d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z" />
                  </svg>
              </a>




              <!-- Youtube -->
              <a href="{{ $setup->youtube }}"
                  class="[&>svg]:h-5 [&>svg]:w-5 p-2 bg-[#191E42] rounded-md  transition-all duration-300 hover:bg-gradient-to-r hover:from-purple-600 hover:to-blue-500 cursor-pointer">
                  <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 576 512">
                      <!--!Font Awesome Free 6.5.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc. -->
                      <path
                          d="M549.7 124.1c-6.3-23.7-24.8-42.3-48.3-48.6C458.8 64 288 64 288 64S117.2 64 74.6 75.5c-23.5 6.3-42 24.9-48.3 48.6-11.4 42.9-11.4 132.3-11.4 132.3s0 89.4 11.4 132.3c6.3 23.7 24.8 41.5 48.3 47.8C117.2 448 288 448 288 448s170.8 0 213.4-11.5c23.5-6.3 42-24.2 48.3-47.8 11.4-42.9 11.4-132.3 11.4-132.3s0-89.4-11.4-132.3zm-317.5 213.5V175.2l142.7 81.2-142.7 81.2z" />
                  </svg>
              </a>


          </div>

      </section>
  @endsection
