@extends('dashboard.app')

@section('content')
    <div class="container mx-auto py-5">
        <div class="card">
            <div class="card-title px-3 pt-3">
                <h3>All Service Posts</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead class="thead-dark">
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Photo</th>
                                <th scope="col">Title</th>
                                <th scope="col">Author</th>
                                <th scope="col">Created At</th>
                                <th scope="col">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($services as $d)
                                <tr>
                                    <th scope="row">{{ $loop->iteration }}</th>
                                    <td>
                                        <img src="{{ asset($d->photo) }}" alt="" style="width: 50px; height: 50px;">
                                    </td>
                                    <td>{{ $d->title }}</td>
                                    <td>{{ Str::limit(strip_tags($d->content), 200, ' ...') }}</td>
                                    <td>{{ $d->created_at->format('D, M Y') }}</td>
                                    <td>

                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <a href="{{ route('service.edit', $d->id) }}" class="btn btn-primary">Edit</a>
                                            {{-- <a href="{{ route('service.show', $d->id) }}" class="btn btn-secondary">View</a> --}}
                                            <a href="{{ route('service.delete', $d->id) }}" class="btn btn-danger">Delete</a>
                                        </div>




                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="card-footer">
                {{ $services->links() }}
            </div>
        </div>
    </div>
@endsection
