@extends('dashboard.app')

@section('content')
    <div class="container mx-auto py-5">
        <div class="card">
            <div class="card-title p-3">
                <h3>Edit</h3>
            </div>
            <div class="card-body">
                <img src="{{ asset($service->photo) }}" style="width: 200px;height:200px" alt="">
                <form action="{{ route('service.update',$service->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <!-- Image Upload (optional) -->
                    <div class="form-group my-3">
                        <label>Title</label>
                        <input required type="text" name="title" class="form-control" value="{{ $service->title }}"
                            placeholder="Write blog title...">
                    </div>
                      <div class="form-group my-3">
                        <label>Cover Photo</label>
                        <input type="file" name="photo" class="form-control">
                    </div>
                    <!-- Summernote Editor for Content -->
                    <textarea required name="content" class="summernote">
                        {{ $service->content }}
                    </textarea>



                    <div class="mt-4">
                        <button type="submit" class="btn btn-success" style="float: right;">Publish</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
