@extends('dashboard.app')

@section('content')
    <div class="container mx-auto py-5">
        <div class="card">
            <div class="card-title p-3">
                <h3>Publish F.A.Q</h3>
            </div>
            <div class="card-body">
                <form action="{{ route('faq.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <!-- Image Upload (optional) -->
                    <div class="form-group my-3">
                        <label>Question</label>
                        <input required type="text" name="question" class="form-control" placeholder="Write a question...">
                    </div>
                    <!-- Summernote Editor for Content -->
                    <label>Answer</label>
                    <textarea required name="answer" class="form-control" rows="5" placeholder="Write content ..."></textarea>



                    <div class="mt-4">
                        <button type="submit" class="btn btn-success" style="float: right;">Publish</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="container mx-auto py-5">
        <div class="card">
            <div class="card-title px-3 pt-3">
                <h3>All F.A.Q</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead class="thead-dark">
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Question</th>
                                <th scope="col">Answer</th>
                                <th scope="col">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($faq as $d)
                                <tr>
                                    <th scope="row">{{ $loop->iteration }}</th>
                                    <td>{{ $d->question }}</td>
                                    <td>{{ Str::limit(strip_tags($d->answer), 200, ' ...') }}</td>
                                    <td>

                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <a href="{{ route('faq.edit', $d->id) }}" class="btn btn-primary">Edit</a>
                                            <a href="{{ route('faq.delete', $d->id) }}" class="btn btn-danger">Delete</a>
                                        </div>




                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="card-footer">
                {{ $faq->links() }}
            </div>
        </div>
    </div>
@endsection
