@extends('dashboard.app')

@section('content')
    <section class="content">
        <div class="container-fluid mt-5">
            <div class="row">
                <div class="col-md-8 offset-md-2">
                    <div class="card card-primary p-4">
                        <div class="card-header mb-4" style="background-color: #343A40">
                            <h3 class="card-title">Front Page Setup</h3>
                        </div>

                        <form action="{{ route('setup.update') }}" method="POST" enctype="multipart/form-data">
                            @csrf




                            {{-- @@@@@@@@@@@@@@@@@@@@@@@@@@ --}}
                            <div class="mb-3 row">
                                <label for="bottle_title" class="col-sm-3 col-form-label">Bottle Title</label>
                                <div class="col-sm-9">
                                    <input type="text" name="bottle_title" value="{{ $setup?->bottle_title }}"
                                        class="form-control" id="bottle_title">
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="bottle_subtitle" class="col-sm-3 col-form-label">Bottle Subtitle</label>
                                <div class="col-sm-9">
                                    <input type="text" name="bottle_subtitle" value="{{ $setup?->bottle_subtitle }}"
                                        class="form-control" id="bottle_subtitle">
                                </div>
                            </div>
                            <hr>
                            <div class="mb-3 row">
                                <label for="signup_title" class="col-sm-3 col-form-label">Signup Title</label>
                                <div class="col-sm-9">
                                    <input type="text" name="signup_title" value="{{ $setup?->signup_title }}"
                                        class="form-control" id="signup_title">
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="signup_subtitle" class="col-sm-3 col-form-label">Signup Subtitle</label>
                                <div class="col-sm-9">
                                    <input type="text" name="signup_subtitle" value="{{ $setup?->signup_subtitle }}"
                                        class="form-control" id="signup_subtitle">
                                </div>
                            </div>
                            {{-- @@@@@@@@@@@@@@@@@@@@@@@@@@ --}}






                            <hr>
                            <!-- Social Links -->
                            @foreach (['facebook', 'youtube', 'instagram'] as $platform)
                                <div class="mb-3 row">
                                    <label for="{{ $platform }}"
                                        class="col-sm-3 col-form-label">{{ ucfirst($platform) }}</label>
                                    <div class="col-sm-9">
                                        <input type="url" name="{{ $platform }}" value="{{ $setup?->$platform }}"
                                            class="form-control" id="{{ $platform }}">
                                    </div>
                                </div>
                            @endforeach
                         
                            <hr>
                            <!-- Bottle Image -->
                            <div class="mb-3 row">
                                <img src="{{ asset($setup?->bottle_image) }}" style="width: 200px" alt="">
                            </div>

                            <div class="mb-3 row">
                                <label for="bottle_image" class="col-sm-3 col-form-label">Bottle Image</label>
                                <div class="col-sm-9">
                                    <input class="form-control" type="file" name="bottle_image" id="bottle_image">
                                </div>
                            </div>

                            <!-- Booking Image -->
                            <div class="mb-3 row">
                                <img src="{{ asset($setup?->booking_image) }}" style="width: 200px" alt="">
                            </div>

                            <div class="mb-3 row">
                                <label for="booking_image" class="col-sm-3 col-form-label">Booking Image</label>
                                <div class="col-sm-9">
                                    <input class="form-control" type="file" name="booking_image" id="booking_image">
                                </div>
                            </div>


                            <div class="mb-3 row">
                                <img src="{{ asset($setup?->booking_card) }}" style="width: 200px" alt="">
                            </div>

                            <div class="mb-3 row">
                                <label for="booking_card" class="col-sm-3 col-form-label">Booking Section Card
                                </label>
                                <div class="col-sm-9">
                                    <input class="form-control" type="file" name="booking_card" id="booking_card">
                                </div>
                            </div>



                            {{-- @@@@@@@@@@@@@@@@@@ --}}
                            <hr>
                            <div class="my-3 bg-light p-3">
                                <small>
                                    Guide :
                                    <br>
                                    Solid Color Example : <strong>#0F0825</strong>
                                    <br>
                                    Gradient Color Example : <strong>linear-gradient(to right, #3b82f6, #ec4899); </strong>
                                </small>
                            </div>



                            <div class="mb-3 row">
                                <label for="main_color" class="col-sm-4 col-form-label">Main Color</label>
                                <div class="col-sm-8">
                                    <input type="text" name="main_color" value="{{ $setup?->main_color }}"
                                        class="form-control" id="main_color">
                                </div>
                            </div>
                            <div class="mb-3 row">
                                <label for="logo_text_color" class="col-sm-4 col-form-label">Logo Text Color Code</label>
                                <div class="col-sm-8">
                                    <input type="text" name="logo_text_color" value="{{ $setup?->logo_text_color }}"
                                        class="form-control" id="logo_text_color">
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="navbar_button_color" class="col-sm-4 col-form-label">Navbar Button Color
                                    Code</label>
                                <div class="col-sm-8">
                                    <input type="text" name="navbar_button_color"
                                        value="{{ $setup?->navbar_button_color }}" class="form-control"
                                        id="navbar_button_color">
                                </div>
                            </div>
                            <div class="mb-3 row">
                                <label for="bottle_color" class="col-sm-4 col-form-label">Bottle Color Code</label>
                                <div class="col-sm-8">
                                    <input type="text" name="bottle_color" value="{{ $setup?->bottle_color }}"
                                        class="form-control" id="bottle_color">
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="signup_color" class="col-sm-4 col-form-label">Signup Color Code</label>
                                <div class="col-sm-8">
                                    <input type="text" name="signup_color" value="{{ $setup?->signup_color }}"
                                        class="form-control" id="signup_color">
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="faq_color" class="col-sm-4 col-form-label">F.A.Q Color Code</label>
                                <div class="col-sm-8">
                                    <input type="text" name="faq_color" value="{{ $setup?->faq_color }}"
                                        class="form-control" id="faq_color">
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="faq_hover_color" class="col-sm-4 col-form-label">F.A.Q <sup>Hover</sup> Color
                                    Code</label>
                                <div class="col-sm-8">
                                    <input type="text" name="faq_hover_color" value="{{ $setup?->faq_hover_color }}"
                                        class="form-control" id="faq_hover_color">
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="navbar_border_color" class="col-sm-4 col-form-label">Navbar Border Color
                                    Code</label>
                                <div class="col-sm-8">
                                    <input type="text" name="navbar_border_color"
                                        value="{{ $setup?->navbar_border_color }}" class="form-control"
                                        id="navbar_border_color">
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="blog_border_color" class="col-sm-4 col-form-label">Blog Border Color</label>
                                <div class="col-sm-8">
                                    <input type="text" name="blog_border_color"
                                        value="{{ $setup?->blog_border_color }}" class="form-control"
                                        id="blog_border_color">
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="blog_button_hover_color" class="col-sm-4 col-form-label">Blog Button
                                    <sup>Hover</sup> Color</label>
                                <div class="col-sm-8">
                                    <input type="text" name="blog_button_hover_color"
                                        value="{{ $setup?->blog_button_hover_color }}" class="form-control"
                                        id="blog_button_hover_color">
                                </div>
                            </div>

                            {{-- @@@@@@@@@@@@@@@@@@@@ --}}
                            <!-- Submit -->
                            <div class="mb-3 row">
                                <button type="submit" class="btn text-white col-12"
                                    style="background: #343A40">Save</button>

                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
