@extends('dashboard.app')

@section('content')
    <div class="container mx-auto">

        <div class="tabs">
            <div role="tablist" aria-label="Legal Pages">
                <button role="tab" aria-selected="true" id="privacy-tab">Privacy Policy</button>
                <button role="tab" aria-selected="false" id="terms-tab">Terms of Service</button>
                <button role="tab" aria-selected="false" id="cookie-tab">Cookie Policy</button>
                <button role="tab" aria-selected="false" id="refund-tab">Refund Policy</button>
            </div>

            <div role="tabpanel" aria-labelledby="privacy-tab" style="padding: 10px;background: #F8F9FA;">
                @foreach ($pages as $d)
                    @if ($d->type == 'privacy')
                        <div class="card-body">
                            <form action="{{ route('legal.store') }}" method="post">
                                @csrf
                                <input type="text" name="type" value="{{ $d->type }}" hidden>
                                <textarea name="content" class="summernote">{!! $d->content !!}</textarea>

                                <div class="py-5">
                                    <button type="submit" class="btn btn-success" style="float: right;">Update</button>
                                </div>

                            </form>
                        </div>
                    @endif
                @endforeach
            </div>
            <div role="tabpanel" aria-labelledby="terms-tab" hidden style="padding: 10px;background: #F8F9FA;">
                @foreach ($pages as $d)
                    @if ($d->type == 'terms')
                        <div class="card-body">
                            <form action="{{ route('legal.store') }}" method="post">
                                @csrf
                            <input type="text" name="type" value="{{ $d->type }}" hidden>
                            <textarea name="content" class="summernote">{!! $d->content !!}</textarea>
                            <div class="py-5">
                                <button type="submit" class="btn btn-success" style="float: right;">Update</button>
                            </div>

                        </form>
                        </div>
                    @endif
                @endforeach
            </div>
            <div role="tabpanel" aria-labelledby="cookie-tab" hidden style="padding: 10px;background: #F8F9FA;">
                @foreach ($pages as $d)
                    @if ($d->type == 'cookie')
                        <div class="card-body">
                            <form action="{{ route('legal.store') }}" method="post">
                                @csrf
                            <input type="text" name="type" value="{{ $d->type }}" hidden>
                            <textarea name="content" class="summernote">{!! $d->content !!}</textarea>
                            <div class="py-5">
                                <button type="submit" class="btn btn-success" style="float: right;">Update</button>
                            </div>

                        </form>
                        </div>
                    @endif
                @endforeach
            </div>
            <div role="tabpanel" aria-labelledby="refund-tab" hidden style="padding: 10px;background: #F8F9FA;">
                @foreach ($pages as $d)
                    @if ($d->type == 'refund')
                        <div class="card-body">
                            <form action="{{ route('legal.store') }}" method="post">
                                @csrf
                            <input type="text" name="type" value="{{ $d->type }}" hidden>
                            <textarea name="content" class="summernote">{!! $d->content !!}</textarea>
                            <div class="py-5">
                                <button type="submit" class="btn btn-success" style="float: right;">Update</button>
                            </div>

                        </form>
                        </div>
                    @endif
                @endforeach
            </div>

        </div>


    </div>

    <style>
        .wrapper {
            max-width: 1000px;
            margin: 4rem auto;
            padding: 2rem;
            background: white;
            box-shadow: 0 0 3px 5px rgba(0, 0, 0, 0.08653);
        }

        .tabs {
            display: grid;
        }

        [role="tablist"] {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            grid-gap: 10px;
        }

        [role="tabpanel"] {
            background: #ffc600;
            padding: 2rem;
            margin-top: 1rem;
        }

        button {
            background: #e7e7e7;
            border: 0;
            color: black;
            border-radius: 5px 5px 0 0;
            --bs-color: rgba(0, 0, 0, 0.1);
            box-shadow: inset 0 -2px 5px var(--bs-color);
            cursor: pointer;
            font-size: 20px;
            padding: 15px;
        }

        button[aria-selected="true"] {
            background: #ffc600;
            box-shadow: none;
            color: rgba(0, 0, 0, 0.7);
        }

        button:focus {
            outline: 0;
            --bs-color: rgba(0, 0, 0, 0.6);
        }
    </style>

    <script>
        const tab = document.querySelector('.tabs');
        const tabButtons = tab.querySelectorAll('[role="tab"]');
        const tabPanels = Array.from(tab.querySelectorAll('[role="tabpanel"]'));

        function tabClickHandler(e) {
            // Hide all tab panels
            tabPanels.forEach(panel => {
                panel.hidden = true;
            });

            // Deselect all tabs
            tabButtons.forEach(button => {
                button.setAttribute('aria-selected', 'false');
            });

            // Activate clicked tab
            e.currentTarget.setAttribute('aria-selected', 'true');

            const id = e.currentTarget.id;
            const currentTab = tabPanels.find(
                panel => panel.getAttribute('aria-labelledby') === id
            );

            if (currentTab) {
                currentTab.hidden = false;
            }
        }

        tabButtons.forEach(button => {
            button.addEventListener('click', tabClickHandler);
        });
    </script>
@endsection
