<?php

namespace Database\Seeders;

use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void


      {
          User::factory()->create([
            'name' => 'Admin',
            'email' => 'admin@nomail.com',
            'password' => Hash::make(12341234),
            'email_verified_at' => now(),
        ]);
        // Seed Users Table
        DB::table('users')->insert([
            'name' => 'John Doe',
            'email' => 'john@example.com',
            'password' => Hash::make('password123'), // Secure hashed password
            'email_verified_at' => now(),
            'remember_token' => Str::random(10),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // Seed Password Reset Tokens Table
        DB::table('password_reset_tokens')->insert([
            'email' => 'john@example.com',
            'token' => Str::random(60),
            'created_at' => now(),
        ]);

        // Seed Sessions Table
        DB::table('sessions')->insert([
            'id' => Str::random(40),
            'user_id' => 1,
            'ip_address' => '192.168.1.1',
            'user_agent' => 'Mozilla/5.0',
            'payload' => serialize(['user_id' => 1]),
            'last_activity' => now()->timestamp,
        ]);

        // Seed Website Setups Table
        // DB::table('website_setups')->insert([
        //     'address' => '123 Main St, Anytown, USA',
        //     'contact' => 'contact@example.com',
        //     'opening_hours' => '9 AM - 6 PM, Mon-Fri',
        //     'facebook' => 'https://facebook.com/example',
        //     'youtube' => 'https://youtube.com/example',
        //     'instagram' => 'https://instagram.com/example',
        //     'clients' => 50,
        //     'projects' => 100,
        //     'hours_support' => 24,
        //     'bottle_image' => 'path/to/bottle_image.jpg',
        //     'booking_image' => 'path/to/booking_image.jpg',
        //     'created_at' => now(),
        //     'updated_at' => now(),
        // ]);

        // Seed Pages Table
        $pages = [
            ['type' => 'privacy', 'content' => 'Privacy Policy content goes here.'],
            ['type' => 'terms', 'content' => 'Terms and Conditions content goes here.'],
            ['type' => 'cookie', 'content' => 'Cookie Policy content goes here.'],
            ['type' => 'refund', 'content' => 'Refund Policy content goes here.'],
        ];

        foreach ($pages as $page) {
            DB::table('pages')->insert($page);
        }

        // Seed Jobs Table
        DB::table('jobs')->insert([
            'queue' => 'default',
            'payload' => serialize(['job' => 'SomeJob', 'data' => ['some' => 'data']]),
            'attempts' => 1,
            'reserved_at' => now()->timestamp,
            'available_at' => now()->timestamp,
            'created_at' => now()->timestamp,
        ]);

        // Seed Job Batches Table
        DB::table('job_batches')->insert([
            'id' => Str::random(32),
            'name' => 'Batch 1',
            'total_jobs' => 10,
            'pending_jobs' => 5,
            'failed_jobs' => 0,
            'failed_job_ids' => '',
            'options' => null,
            'cancelled_at' => null,
            'created_at' => now()->timestamp,
            'finished_at' => null,
        ]);

        // Seed Failed Jobs Table
        DB::table('failed_jobs')->insert([
            'uuid' => Str::uuid(),
            'connection' => 'database',
            'queue' => 'default',
            'payload' => serialize(['job' => 'FailedJob', 'data' => ['error' => 'Some error']]),
            'exception' => 'Some exception message',
            'failed_at' => now(),
        ]);
    }
}
