<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('website_setups', function (Blueprint $table) {
            // Color codes
            $table->string('main_color')->nullable();
            $table->string('bottle_color')->nullable();
            $table->string('signup_color')->nullable();
            $table->string('faq_color')->nullable();
            $table->string('faq_hover_color')->nullable();
            $table->string('navbar_border_color')->nullable();
            $table->string('blog_border_color')->nullable();
            $table->string('blog_button_hover_color')->nullable();
            $table->string('logo_text_color')->nullable();
            $table->string('navbar_button_color')->nullable();

            // Titles and subtitles
            $table->string('bottle_title')->nullable();
            $table->string('bottle_subtitle')->nullable();
            $table->string('signup_title')->nullable();
            $table->string('signup_subtitle')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('website_setups', function (Blueprint $table) {
            //
        });
    }
};
