<?php

namespace App\Providers;

use App\Models\Service;
use App\Models\website_setup;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use Illuminate\Pagination\Paginator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
          Paginator::useBootstrap();
        $setup = website_setup::first();
        $services = Service::all();
        View::share(compact('setup', 'services'));
    }
}
