<?php

namespace App;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
trait ImageUpload
{
    /**
     * Upload and set the image path on the model.
     *
     * @param Request $request
     * @param string $inputName
     * @param string $column
     * @param string $folder
     * @return void
     */
    public function uploadImage(Request $request, $inputName = 'image', $column = 'image_path', $folder = 'uploads')
    {
        if ($request->hasFile($inputName)) {
            // Delete old image if exists
            if ($this->$column && File::exists(public_path($this->$column))) {
                File::delete(public_path($this->$column));
            }

            // Get the uploaded file
            $image = $request->file($inputName);

            // Generate a unique file name and move the file to the folder
            $imageName = time() . '_' . $image->getClientOriginalName();
            $imagePath = $image->move(public_path($folder), $imageName);

            // Save the new image path in the database
            $this->$column = $folder . '/' . $imageName;
            $this->save();
        }
    }

    /**
     * Delete the image from the public directory.
     *
     * @param string $column
     * @return void
     */
    public function deleteImage($column = 'image_path')
    {
        if ($this->$column && File::exists(public_path($this->$column))) {
            File::delete(public_path($this->$column));
        }
    }

    /**
     * Boot the trait to delete image on model deletion.
     */
    protected static function bootImageTrait()
    {
        static::deleting(function ($model) {
            $model->deleteImage();
        });
    }
}
