<?php

namespace App\Http\Controllers;

use App\Models\Page;
use App\Models\website_setup;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class WebsiteSetupController extends Controller
{
    function index()
    {

        $setup = website_setup::first(); // Or Setup::find(1);
        return view('dashboard.setup.index', compact('setup'));
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'address' => 'nullable|string|max:255',
            'contact' => 'nullable|string|max:255',
            'opening_hours' => 'nullable|string|max:255',
            'facebook' => 'nullable|url',
            'youtube' => 'nullable|url',
            'instagram' => 'nullable|url',
            'clients' => 'nullable|integer',
            'projects' => 'nullable|integer',
            'hours_support' => 'nullable|integer',
            'bottle_image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:10240',
            'booking_image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:10240',

            // New color code fields
            'main_color' => 'required|string', // assuming hex color code like #FFFFFF
            'bottle_color' => 'required|string',
            'signup_color' => 'required|string',
            'faq_color' => 'required|string',
            'faq_hover_color' => 'required|string',
            'navbar_border_color' => 'required|string',
            'blog_border_color' => 'required|string',
            'blog_button_hover_color' => 'required|string',
            'logo_text_color' => 'required|string',
            'navbar_button_color' => 'required|string',

            // Titles and subtitles
            'bottle_title' => 'required|string',
            'bottle_subtitle' => 'required|string',
            'signup_title' => 'required|string',
            'signup_subtitle' => 'required|string',
        ]);

        if ($validator->fails()) {
            foreach ($validator->errors()->all() as $error) {
                flash()->error($error);
            }
            return back(); // Stop execution if validation fails
        }

        $validated = $validator->validated();
        $setup = website_setup::first();

        if (!$setup) {
            $setup = new website_setup();
        }

        // Create directory if not exists
        $uploadPath = public_path('uploads/images');
        if (!file_exists($uploadPath)) {
            mkdir($uploadPath, 0755, true);
        }

        // Bottle image upload
        if ($request->hasFile('bottle_image')) {
            if ($setup->bottle_image && file_exists(public_path($setup->bottle_image))) {
                unlink(public_path($setup->bottle_image));
            }

            $file = $request->file('bottle_image');
            $fileName = uniqid() . '_' . $file->getClientOriginalName();
            $file->move($uploadPath, $fileName);
            $validated['bottle_image'] = 'uploads/images/' . $fileName;
        }

        // Booking image upload
        if ($request->hasFile('booking_image')) {
            if ($setup->booking_image && file_exists(public_path($setup->booking_image))) {
                unlink(public_path($setup->booking_image));
            }

            $file = $request->file('booking_image');
            $fileName = uniqid() . '_' . $file->getClientOriginalName();
            $file->move($uploadPath, $fileName);
            $validated['booking_image'] = 'uploads/images/' . $fileName;
        }

        if ($request->hasFile('booking_card')) {
            if ($setup->booking_card && file_exists(public_path($setup->booking_card))) {
                unlink(public_path($setup->booking_card));
            }

            $file = $request->file('booking_card');
            $fileName = uniqid() . '_' . $file->getClientOriginalName();
            $file->move($uploadPath, $fileName);
            $validated['booking_card'] = 'uploads/images/' . $fileName;
        }

        $setup->fill($validated);
        $setup->save();

        flash()->success('Website setup updated successfully');
        return back();
    }

    function legal()
    {
        $pages = Page::all(); // Or Setup::find(1);
        return view('dashboard.legal.index', compact('pages'));
    }

    function legalStore(Request $request)
    {

        Page::where('type', $request->type)->update([
            'content' => $request->content
        ]);
        flash()->success('Legal page updated successfully');

        return back();
    }
}
