<?php

namespace App\Http\Controllers;

use App\Models\Faq;
use Illuminate\Http\Request;

class FaqController extends Controller
{
 public function index()
    {
        $faq = Faq::paginate(10); // Retrieve all blogs
        return view('faq.index', compact('faq')); // Return the view with blogs
    }

    /**
     * Show the form for creating a new blog.
     */
    public function create()
    {
        return view('faq.create'); // Return the create form view
    }

    /**
     * Store a newly created blog in the database.
     */
    public function store(Request $request)
    {


        Faq::create($request->only('question', 'answer'));




        flash()->success('F.A.Q created successfully.');
        return back(); // Redirect to the blog index
    }

    /**
     * Display the specified blog.
     */
    public function show(Faq $faq)
    {
        return view('article', compact('faq')); // Show the specific blog
    }

    /**
     * Show the form for editing the specified blog.
     */
    public function edit(Faq $faq)
    {
        return view('faq.edit', compact('faq')); // Return the edit form view
    }

    /**
     * Update the specified blog in the database.
     */
    public function update(Request $request, Faq $faq)
    {
        $request->validate([
            'question' => 'required|string',
            'answer' => 'required|string',
        ]);

        $faq->update($request->only('question', 'answer'));


        flash()->success('F.A.Q updated successfully.');
        return redirect(
            route('faq.index')
        ); // Redirect to the blog index
    }

    /**
     * Remove the specified blog from the database.
     */
    public function destroy(Faq $faq)
    {

        $faq->delete(); // Auto deletes the image when the blog is deleted
        flash()->success('F.A.Q deleted successfully.');
        return back(); // Redirect to the blog index
    }
}
