<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreModelEntityRequest;
use App\Http\Requests\UpdateModelEntityRequest;
use App\Models\ModelEntity;
use Illuminate\Http\Request;

class EntityController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $entities = ModelEntity::all();
    
        return view('dashboard.model.index',compact('entities'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreModelEntityRequest $request)
    {
        // return $request;
        ModelEntity::create($request->all()); // unsafe if $fillable is missing or request has extra fields
        toastr()->success('Entity created!');
        return back();
    }

    /**
     * Display the specified resource.
     */
    public function show(ModelEntity $entity)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ModelEntity $entity)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateModelEntityRequest $request, ModelEntity $entity)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ModelEntity $entity)
    {
        //
    }
}
